/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.listeners;

import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.event.EventHandler;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.listeners.LoginProfileListener;

public class LoginListener
extends LoginProfileListener
implements Listener {
    private final SkinsRestorer plugin;

    @EventHandler(priority=32)
    public void onLogin(LoginEvent event) {
        LoginProfileEvent profileEvent = this.wrap(event);
        if (this.handleSync(profileEvent)) {
            return;
        }
        event.registerIntent((Plugin)this.plugin);
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            this.handleAsync(profileEvent).ifPresent(name -> {
                try {
                    this.plugin.getSkinApplierBungee().applySkin((String)name, (InitialHandler)event.getConnection());
                }
                catch (SkinRequestException e) {
                    this.plugin.getSrLogger().debug(e);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            });
            event.completeIntent((Plugin)this.plugin);
        });
    }

    private LoginProfileEvent wrap(final LoginEvent event) {
        return new LoginProfileEvent(){

            @Override
            public boolean isOnline() {
                return event.getConnection().isOnlineMode();
            }

            @Override
            public String getPlayerName() {
                return event.getConnection().getName();
            }

            @Override
            public boolean isCancelled() {
                return event.isCancelled();
            }
        };
    }

    public LoginListener(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

